import os
import sys
import subprocess

from kivy.app import App
from kivy.lang import Builder
from kivy.core.window import Window
from kivy.uix.popup import Popup
from kivy.uix.label import Label
from kivy.clock import Clock

# Fenstergröße (optional)
Window.size = (1920, 1080)

KV = "menu.kv"
Builder.load_file(KV)

from kivy.uix.screenmanager import ScreenManager, Screen, FadeTransition

class MainMenu(Screen):
    pass

class Root(ScreenManager):
    pass

class SimpleMenuApp(App):
    def build(self):
        self.sm = Root(transition=FadeTransition())
        return self.sm

    def play_game(self):
        """Startet game_highway.py mit aktuellen Python-Interpreter.
           Kein Ergebnis-Watcher, kein JSON-Handling mehr — nur starten.
        """
        script_path = os.path.join(os.path.dirname(__file__), "game_highway.py")
        if not os.path.exists(script_path):
            Popup(title="Fehler", content=Label(text=f"Spieldatei fehlt:\n{script_path}"),
                  size_hint=(0.8, 0.3)).open()
            return

        python = sys.executable or "python"
        args = [python, script_path]

        # Zeige kurzes Launch-Popup
        try:
            popup = Popup(title="Start", content=Label(text="Spiel wird gestartet..."), size_hint=(0.4,0.2))
            popup.open()
        except Exception:
            popup = None

        try:
            # Starten ohne stdout/stderr capture — ganz einfach
            subprocess.Popen(args, cwd=os.path.dirname(__file__))
        except Exception as e:
            if popup:
                popup.dismiss()
            Popup(title="Startfehler", content=Label(text=str(e)), size_hint=(0.8,0.3)).open()
            return

        # Popup kurz schließen
        if popup:
            Clock.schedule_once(lambda dt: popup.dismiss(), 0.8)

if __name__ == "__main__":
    SimpleMenuApp().run()