# PongGame.py

from kivy.uix.widget import Widget
from kivy.properties import ObjectProperty
from random import random, randint
from kivy.vector import Vector

class PongGame(Widget):
    ball = ObjectProperty(None)
    player1 = ObjectProperty(None)
    player2 = ObjectProperty(None)

    speed_timer = 0

    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        self.up_pressed = False
        self.down_pressed = False

    def serve_ball(self, vel=(4, 0)):
        self.ball.center = self.center
        self.ball.velocity = Vector(*vel).rotate(randint(-45, 45))
        self.speed_timer = 0

    def update(self, dt):
        self.ball.move()
        self.speed_timer += dt

        if self.speed_timer > 5:
            self.ball.velocity = (
                self.ball.velocity_x * 1.1,
                self.ball.velocity_y * 1.1
            )
            self.speed_timer = 0

        if self.ball.y < 0 or self.ball.top > self.height:
            self.ball.velocity_y *= -1

        self.player1.bounce_ball(self.ball)
        self.player2.bounce_ball(self.ball)

        self.ai_move()

        if self.ball.x < 0:
            self.player2.score += 1
            self.serve_ball((4, 0))

        if self.ball.right > self.width:
            self.player1.score += 1
            self.serve_ball((-4, 0))

        # kontinuierliche Bewegung linkes Paddle
        speed = 6
        if self.up_pressed:
            self.player1.y = min(self.height - self.player1.height, self.player1.y + speed)
        if self.down_pressed:
            self.player1.y = max(0, self.player1.y - speed)

    def ai_move(self):
        if random() < 0.1:
            return
        speed = 6
        if self.ball.center_y > self.player2.center_y + 10:
            self.player2.y += speed
        elif self.ball.center_y < self.player2.center_y - 10:
            self.player2.y -= speed

    def keyboard_action(self, window, key, scancode, codepoint, modifiers):
        # Pfeile oder W/S
        if key == 273 or codepoint == "w":
            self.up_pressed = True
            return True
        elif key == 274 or codepoint == "s":
            self.down_pressed = True
            return True
        return False

    def keyboard_release(self, window, key, scancode=None, codepoint=None, modifiers=None):
        if key == 273 or codepoint == "w":
            self.up_pressed = False
            return True
        elif key == 274 or codepoint == "s":
            self.down_pressed = False
            return True
        return False
