# PongApp.py

from kivy.app import App
from kivy.clock import Clock
from kivy.core.window import Window
from kivy.uix.screenmanager import ScreenManager, Screen
from kivy.uix.boxlayout import BoxLayout
from kivy.uix.button import Button

from PongBall import PongBall
from PongPaddle import PongPaddle
from PongGame import PongGame

# --- Startbildschirm ---
class StartScreen(Screen):
    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        layout = BoxLayout(orientation='vertical', spacing=20, padding=50)
        
        # Schwierigkeits-Buttons
        easy_btn = Button(text="Einfach", font_size=32)
        medium_btn = Button(text="Mittel", font_size=32)
        hard_btn = Button(text="Schwer", font_size=32)
        layout.add_widget(easy_btn)
        layout.add_widget(medium_btn)
        layout.add_widget(hard_btn)
        self.add_widget(layout)

        easy_btn.bind(on_release=lambda x: self.start_game("easy"))
        medium_btn.bind(on_release=lambda x: self.start_game("medium"))
        hard_btn.bind(on_release=lambda x: self.start_game("hard"))

    def start_game(self, difficulty):
        app = App.get_running_app()
        app.start_game(difficulty)

# --- Haupt-App ---
class PongApp(App):
    kv_file = None

    def build(self):
        self.sm = ScreenManager()
        self.start_screen = StartScreen(name="start")
        self.sm.add_widget(self.start_screen)
        return self.sm

    def start_game(self, difficulty):
        game = PongGame()
        game.serve_ball()

        # Keyboard-Bindings für flüssige Bewegung
        Window.bind(on_key_down=game.keyboard_action)
        Window.bind(on_key_up=game.keyboard_release)

        # Schwierigkeitsgrad einstellen (AI Geschwindigkeit & Fehlerchance)
        if difficulty == "easy":
            game.ai_speed = 4
            game.error_chance = 0.3
        elif difficulty == "medium":
            game.ai_speed = 6
            game.error_chance = 0.15
        elif difficulty == "hard":
            game.ai_speed = 9
            game.error_chance = 0.05

        # Spiel-Loop starten
        clock_event = Clock.schedule_interval(game.update, 1/60.)

        # Spiel-Screen erstellen
        game_screen = Screen(name="game")
        game_screen.add_widget(game)

        # Zurück-Button hinzufügen
        back_btn = Button(text="Zurück", size_hint=(0.2, 0.1), pos_hint={"x":0.8, "y":0.9})
        game_screen.add_widget(back_btn)

        def go_back(instance):
            # Clock stoppen
            clock_event.cancel()
            # Screen wechseln
            self.sm.current = "start"
            # Spiel-Screen entfernen
            self.sm.remove_widget(game_screen)

        back_btn.bind(on_release=go_back)

        self.sm.add_widget(game_screen)
        self.sm.current = "game"


if __name__ == "__main__":
    PongApp().run()
