from kivy.uix.widget import Widget
from kivy.properties import NumericProperty
from kivy.vector import Vector

class PongPaddle(Widget):
    score = NumericProperty(0)

    def bounce_ball(self, ball):
        if self.collide_widget(ball):
            vx, vy = ball.velocity
            offset = (ball.center_y - self.center_y) / (self.height / 2)
            bounced = Vector(-vx, vy)
            ball.velocity = bounced.x * 1.1, (bounced.y + offset) * 1.1
