from kivy.uix.screenmanager import Screen, ScreenManager
from kivy.uix.boxlayout import BoxLayout
from kivy.uix.button import Button

class MenuScreen(Screen):
    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        layout = BoxLayout(orientation="vertical", spacing=20, padding=50)
        
        easy_btn = Button(text="Einfach")
        easy_btn.bind(on_release=lambda x: self.start_game("easy"))
        layout.add_widget(easy_btn)

        medium_btn = Button(text="Mittel")
        medium_btn.bind(on_release=lambda x: self.start_game("medium"))
        layout.add_widget(medium_btn)

        hard_btn = Button(text="Schwer")
        hard_btn.bind(on_release=lambda x: self.start_game("hard"))
        layout.add_widget(hard_btn)

        self.add_widget(layout)

    def start_game(self, difficulty):
        # Speichert die Schwierigkeit im ScreenManager
        self.manager.get_screen("game").set_difficulty(difficulty)
        self.manager.current = "game"

class GameScreen(Screen):
    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        from PongGame import PongGame
        self.game = PongGame()
        self.add_widget(self.game)

    def set_difficulty(self, difficulty):
        """Schwierigkeitsgrad einstellen, z.B. KI-Geschwindigkeit"""
        if difficulty == "easy":
            self.game.ai_speed = 4
            self.game.error_chance = 0.3
        elif difficulty == "medium":
            self.game.ai_speed = 6
            self.game.error_chance = 0.15
        elif difficulty == "hard":
            self.game.ai_speed = 10
            self.game.error_chance = 0.05
        self.game.serve_ball()

class PongScreenManager(ScreenManager):
    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        self.add_widget(MenuScreen(name="menu"))
        self.add_widget(GameScreen(name="game"))
